module Fastlane
  module Actions
    class GenerateBuildInfoAction < Action
      def self.run(params)
        UI.message ""
        UI.message Terminal::Table.new(
          title: "Generate Build Info".green,
          headings: ["Option", "Value"],
          rows: params.values,
        )
        UI.message ""

        text = File.read(params[:version_file])
        new_content = text.gsub("BuildNumber = \"UNKNOWN\"", "BuildNumber = \"#{params[:build_number]}\"")
        new_content = new_content.gsub("Commit = \"UNKNOWN\"", "Commit = \"#{params[:commit_sha]}\"")
        new_content = new_content.gsub("Branch = \"UNKNOWN\"", "Branch = \"#{params[:branch]}\"")

        commit_time = `git show -s --format=%ct #{params[:commit_sha]}`
        new_content = new_content.gsub("BuildDate = -1", "BuildDate = #{commit_time}")
        # puts new_content
        File.open(params[:version_file], "w") { |file| file.puts new_content }

        UI.success "Completed"
      end

      #####################################################
      # @!group Documentation
      #####################################################

      def self.description
        "Change Build number"
      end

      def self.available_options
        [
          FastlaneCore::ConfigItem.new(key: :version_file,
                                       env_name: "VERSION_FILE",
                                       description: "Path for Version file",
                                       optional: true,
                                       default_value: "Assets/Scripts/Version.cs"),
          FastlaneCore::ConfigItem.new(key: :build_number,
                                       env_name: "BUILD_NUMBER",
                                       description: "Build number",
                                       optional: true,
                                       default_value: ENV["CI_PIPELINE_ID"]),
          FastlaneCore::ConfigItem.new(key: :commit_sha,
                                       env_name: "COMMIT_SHA",
                                       description: "Commit SHA",
                                       optional: true,
                                       default_value: ENV["CI_COMMIT_SHA"]),
          FastlaneCore::ConfigItem.new(key: :branch,
                                       env_name: "BRANCH_NAME",
                                       description: "Branch name",
                                       optional: true,
                                       default_value: ENV["CI_COMMIT_REF_NAME"]),
        ]
      end

      def self.authors
        ["Vadim Vlasov"]
      end

      def self.is_supported?(platform)
        [:ios, :android, :windows, :macos].include?(platform)
      end
    end
  end
end
