module Fastlane
  module Actions
    class ChangeloggerAction < Action
      def self.run(params)
        sh("changelogger -channel-name=\"#{params[:channel]}\" -mattermost-token=\"#{params[:mattermost_token]}\" -mattermost-server=\"#{params[:matttermost_server]}\" -mattermost-message=\"#{params[:message]}\"")
      end

      #####################################################
      # @!group Documentation
      #####################################################

      def self.description
        "Составления списка изменений между текущим Pipeline и последним успешным Pipeline. Возможна отправка сообщения в Mattermost."
      end

      def self.available_options
        [
          FastlaneCore::ConfigItem.new(key: :channel,
                                       env_name: "MATTERMOST_CHANNEL",
                                       description: "Название канала в Mattermost для отправки списка изменений",
                                       default_value: nil),
          FastlaneCore::ConfigItem.new(key: :mattermost_token,
                                       env_name: "MATTERMOST_TOKEN",
                                       description: "Access Token бота, созданного в Mattermost",
                                       default_value: nil),
          FastlaneCore::ConfigItem.new(key: :message,
                                       env_name: "MATTERMOST_MESSAGE",
                                       description: "Сообщение",
                                       default_value: nil),
          FastlaneCore::ConfigItem.new(key: :matttermost_server,
                                       env_name: "MATTERMOST_SERVER",
                                       description: "Адрес Mattermost сервера (например: http://chat.furylion.net",
                                       default_value: "http://192.168.1.20:8066"),
          FastlaneCore::ConfigItem.new(key: :gitlab_token,
                                       env_name: "CHANGELOG_TOKEN",
                                       description: "GitLab Token для генерации списка изменений",
                                       default_value: nil),
        ]
      end

      def self.authors
        ["Vadim Vlasov"]
      end

      def self.is_supported?(platform)
        true
      end
    end
  end
end
