module Fastlane
  module Actions
    class MattermostAction < Action
      def self.run(params)
        changelog = sh("changelogger")

        message = "{"
        message << "\"icon_url\": \"#{params[:icon]}\"," if params[:icon]
        message << "\"username\": \"#{params[:username]}\"," if params[:username]
        message << "\"attachments\": [{ \"color\": \"#FF8000\", \"pretext\": \"<!channel>\", \"title\": \"#{params[:message]}\", \"fields\": [{ \"short\": false, \"title\": \"Изменения:\", \"value\": \"#{changelog}\" }] }]"
        message << "}"

        request = "curl -i -X POST -H 'Content-Type: application/json' -d '" << message << "' " << params[:webhook]
        sh request
      end

      #####################################################
      # @!group Documentation
      #####################################################

      def self.description
        "Send message to Mattermost"
      end

      def self.available_options
        [
          FastlaneCore::ConfigItem.new(key: :icon,
                                       env_name: "MATTERMOST_ICON",
                                       description: "URL для иконки",
                                       optional: true,
                                       default_value: nil),
          FastlaneCore::ConfigItem.new(key: :username,
                                       env_name: "MATTERMOST_USER",
                                       description: "Имя пользователя",
                                       optional: true,
                                       default_value: nil),
          FastlaneCore::ConfigItem.new(key: :message,
                                       env_name: "MATTERMOST_MESSAGE",
                                       description: "Сообщение",
                                       default_value: nil),
          FastlaneCore::ConfigItem.new(key: :webhook,
                                       env_name: "MATTERMOST_WEBHOOK",
                                       description: "Mattermost Webhook (например: http://chat.furylion.net/hooks/XXXXXXXX",
                                       default_value: nil),
          FastlaneCore::ConfigItem.new(key: :gitlab_token,
                                       env_name: "CHANGELOG_TOKEN",
                                       description: "GitLab Token для генерации списка изменений",
                                       default_value: nil),
        ]
      end

      def self.authors
        ["Vadim Vlasov"]
      end

      def self.is_supported?(platform)
        true
      end
    end
  end
end
