module Fastlane
  module Actions
    class RemoveProvisioningProfilesAction < Action
      def self.run(params)
        UI.message "Remove Provisioning Profiles"
        sh "rm -f #{params[:path]}"
        UI.success "Completed"
      end

      #####################################################
      # @!group Documentation
      #####################################################

      def self.description
        "Remove Provisioning Profiles"
      end

      def self.available_options
        [
          FastlaneCore::ConfigItem.new(key: :path,
                                       env_name: "REMOVE_PROVISIONING_PROFILES_PATH",
                                       description: "Путь до директории, где хранятся Provisioning Profiles",
                                       optional: true,
                                       default_value: "~/Library/MobileDevice/Provisioning\ Profiles/*"),
        ]
      end

      def self.authors
        ["Vadim Vlasov"]
      end

      def self.is_supported?(platform)
        [:ios].include?(platform)
      end
    end
  end
end
