module Fastlane
  module Actions
    class TryUpdateCacheAction < Action
      def self.run(params)
        # if params[:ignore_cache]
        #   UI.message("Skipping cache restoration.")
        #   return
        # end

        branch = ENV['CI_COMMIT_BRANCH']
        allowed_update_branches = params[:allowed_update_branches]
        directory = params[:directory]
        cache_storage_path = params[:cache_storage_path]

        if allowed_update_branches.include?(branch)
          UI.message("Updating cache...")
          
          # Create cache storage directory if it doesn't exist
          FileUtils.mkdir_p(cache_storage_path) unless Dir.exist?(cache_storage_path)
          
          output = `rsync -a --delete #{directory}/ #{cache_storage_path}/`
          puts output unless output.strip.empty?

          UI.success("Cache saved in #{cache_storage_path}")
        else
          UI.message("Cache not updated as the branch (#{branch}) is not in the allowed update list")
        end
      end

      def self.description
        "Saves the cache from a local directory to a specified storage path if the current branch is allowed"
      end

      def self.authors
        ["Vadim Vlasov"]
      end

      def self.available_options
        [
          FastlaneCore::ConfigItem.new(key: :allowed_update_branches,
                                       description: "List of branches that are allowed to update the cache",
                                       optional: true,
                                       default_value: ["develop"],
                                       type: Array),
          FastlaneCore::ConfigItem.new(key: :directory,
                                       description: "Local directory from which the cache will be saved",
                                       optional: true,
                                       default_value: "Library",
                                       type: String),
          FastlaneCore::ConfigItem.new(key: :cache_storage_path,
                                       description: "Storage path where the cache will be saved",
                                       optional: true,
                                       default_value: "/Volumes/DataSSD/Cache/#{ENV['CI_PROJECT_PATH']}/Library",
                                       env_name: "CACHE_STORAGE_PATH",
                                       type: String),
          FastlaneCore::ConfigItem.new(key: :ignore_cache,
                                       env_name: "IGNORE_CACHE",
                                       description: "If set, cache restoration will be skipped",
                                       optional: true,
                                       is_string: false,
                                       default_value: false)
        ]
      end

      def self.is_supported?(platform)
        true
      end
    end
  end
end